.386P
.MODEL FLAT,C

_TEXT SEGMENT DWORD PUBLIC 'CODE'
        ASSUME CS:_TEXT,DS:_DATA

; - interface ---------------------------------------------------------------
public  SummTexture_ASM
extrn shadetable: byte

public  BlurTexture_ASM

public  FlipTexture_ASM

public  BumpTexture_ASM

; - implementacio -----------------------------------------------------------
; - textura osszeado mag ----------------------------------------------------
SummTexture_ASM     PROC NEAR
                    ; parameterek: EDI:= destptr, ESI:= srcptr, EDX:= weigth

                    mov ecx,4*256*256 ; textura merete
                    mov dh,dl ; DL:= suly
                    xor dh,0FFh ; DH:= -suly

aNxtPix:            movzx eax,byte ptr [edi] ; cel pixel be
                    movzx ebx,byte ptr [esi] ; forras pixel be
                    mov ah,dl ; cel suly be
                    mov bh,dh ; forras suly be
                    movzx eax,byte ptr shadetable[eax]
                    movzx ebx,byte ptr shadetable[ebx]

                    add ax,bx
                    stosb ; pixel ki

                    inc esi ; kovetkezo pixel
                    dec ecx
                    jnz aNxtPix

                    ret

SummTexture_ASM     ENDP

; - textura elkeno mag ------------------------------------------------------
BlurTexture_ASM     PROC NEAR
                    ; parameterek: EDI:= destptr, ESI:= srcptr, EDX:= fazisok

bNxtPhase:          push esi
                    push edi
                    push esi
                    push edi

                    mov ecx,4*256 ; felso sor elkenese
buNxtPix:           movzx ax,byte ptr [esi + 4*255*256] ; "felette" (legalso sor)
                    movzx bx,byte ptr [esi + 4*256] ; alatta
                    add ax,bx
                    mov bl,byte ptr [esi - 4] ; balra
                    add ax,bx
                    mov bl,byte ptr [esi + 4] ; jobbra
                    add ax,bx
                    shr ax,2 ; /4
                    stosb ; pixel ki
                    inc esi ; kovetkezo pixel
                    dec ecx
                    jnz buNxtPix

                    mov ecx,4*256*254 ; kozepso 254 sor elkenese
bNxtPix:            movzx ax,byte ptr [esi - 4*256] ; felette
                    movzx bx,byte ptr [esi + 4*256] ; alatta
                    add ax,bx
                    mov bl,byte ptr [esi - 4] ; balra
                    add ax,bx
                    mov bl,byte ptr [esi + 4] ; jobbra
                    add ax,bx
                    shr ax,2 ; /4
                    stosb ; pixel ki
                    inc esi ; kovetkezo pixel
                    dec ecx
                    jnz bNxtPix

                    mov ecx,4*256 ; also sor elkenese
bdNxtPix:           movzx ax,byte ptr [esi - 4*256] ; felette
                    movzx bx,byte ptr [esi - 4*255*256] ; "alatta" (legfelso sor)
                    add ax,bx
                    mov bl,byte ptr [esi - 4] ; balra
                    add ax,bx
                    mov bl,byte ptr [esi + 4] ; jobbra
                    add ax,bx
                    shr ax,2 ; /4
                    stosb ; pixel ki
                    inc esi ; kovetkezo pixel
                    dec ecx
                    jnz bdNxtPix

                    pop esi ; elkent kep visszamasolasa a kovetkezo fazishoz
                    pop edi
                    mov ecx,256*256
                    rep movsd

                    pop edi ; kovetkezo fazis
                    pop esi
                    dec edx
                    jnz bNxtPhase

                    ret

BlurTexture_ASM     ENDP

; - textura atfordito mag ---------------------------------------------------
FlipTexture_ASM     PROC NEAR
                    ; parameterek: EDI:= destptr, ESI:= srcptr

                    mov ecx,256*256 ; textura merete
                    add esi,4*(256*256 - 1)

fNxtPix:            mov al,byte ptr [esi] ; RGB -> BRG pixelkonverzio
                    mov byte ptr [edi + 1],al
                    mov al,byte ptr [esi + 1]
                    mov byte ptr [edi + 2],al
                    mov al,byte ptr [esi + 2]
                    mov byte ptr [edi + 0],al

                    sub esi,4 ; kovetkezo pixel
                    add edi,4
                    dec ecx
                    jnz fNxtPix

                    ret

FlipTexture_ASM     ENDP

; - textura bump-olo mag ----------------------------------------------------
bumpx   dw 0
bumpy   dw 0

BumpTexture_ASM     PROC NEAR
                    ; parameterek: EDI:= destptr, ESI:= srcptr, EDX:= bumpmapptr

                    mov [bumpy],0

                    mov [bumpx],0 ; felso sor bump-olasa
uuNxtPix:           movzx ebx,byte ptr [edx - 4 + 1]
                    sub bl,byte ptr [edx + 4 + 1]
                    add bx,[bumpx] ; BL:= x + dX
                    movzx ecx,byte ptr [edx + 4*255*256 + 1]
                    sub cl,byte ptr [edx + 4*256 + 1]
                    add cx,[bumpy] ; CL:= y + dY
                    mov bh,cl
                    sal ebx,2 ; BX:= 4*(256*(y + dY) + (x + dX))
                    mov eax,dword ptr [esi + ebx] ; pixel be (glassbump G-vel)
                    mov dword ptr [edi],eax
                    add edi,4 ; kovetkezo pixel
                    add edx,4
                    inc [bumpx]
                    cmp [bumpx],256
                    jb uuNxtPix

uNxtLin:            mov [bumpx],0 ; kozepso 254 sor bump-olasa
uNxtPix:            movzx ebx,byte ptr [edx - 4 + 1]
                    sub bl,byte ptr [edx + 4 + 1]
                    add bx,[bumpx] ; BL:= x + dX
                    movzx ecx,byte ptr [edx - 4*256 + 1]
                    sub cl,byte ptr [edx + 4*256 + 1]
                    add cx,[bumpy] ; CL:= y + dY
                    mov bh,cl
                    sal ebx,2 ; BX:= 4*(256*(y + dY) + (x + dX))
                    mov eax,dword ptr [esi + ebx] ; pixel be (glassbump G-vel)
                    mov dword ptr [edi],eax
                    add edi,4 ; kovetkezo pixel
                    add edx,4
                    inc [bumpx]
                    cmp [bumpx],256
                    jb uNxtPix
                    inc [bumpy] ; kovetkezo sor
                    cmp [bumpy],255
                    jb uNxtLin

                    mov [bumpx],0 ; felso sor bump-olasa
udNxtPix:           movzx ebx,byte ptr [edx - 4 + 1]
                    sub bl,byte ptr [edx + 4 + 1]
                    add bx,[bumpx] ; BL:= x + dX
                    movzx ecx,byte ptr [edx - 4*256 + 1]
                    sub cl,byte ptr [edx - 4*255*256 + 1]
                    add cx,[bumpy] ; CL:= y + dY
                    mov bh,cl
                    sal ebx,2 ; BX:= 4*(256*(y + dY) + (x + dX))
                    mov eax,dword ptr [esi + ebx] ; pixel be (glassbump G-vel)
                    mov dword ptr [edi],eax
                    add edi,4 ; kovetkezo pixel
                    add edx,4
                    inc [bumpx]
                    cmp [bumpx],256
                    jb udNxtPix


                    ret

BumpTexture_ASM     ENDP

_TEXT ENDS

END